import { ethers } from 'ethers'
import { ErrorDecoder } from 'ethers-decode-error'

import * as AccessControlAbi from '../assets/cmkv5/AccessControl.json'
import * as ERC2771CustomForwarderAbi from '../assets/cmkv5/ERC2771CustomForwarder.json'
import * as IdentityRegistryAbi from '../assets/cmkv5/IdentityRegistry.json'
import * as InterestPaymentAbi from '../assets/cmkv5/InterestPayment.json'
import * as PurchaseContractAbi from '../assets/cmkv5/PurchaseContract.json'
import * as RestrictedLockupTokenAbi from '../assets/cmkv5/RestrictedLockupToken.json'
import * as RestrictedLockupTokenExtensionAbi from '../assets/cmkv5/RestrictedLockupTokenExtension.json'
import * as RestrictedLockupTokenManagementExtensionAbi from '../assets/cmkv5/RestrictedLockupTokenManagementExtension.json'
import * as RestrictedSwapAbi from '../assets/cmkv5/RestrictedSwap.json'
import * as SnapshotPeriodsAbi from '../assets/cmkv5/SnapshotPeriods.json'
import * as TransferRulesAbi from '../assets/cmkv5/TransferRules.json'

export const forwarderContract = (
  address: string,
  signer: ethers.Signer,
): ethers.Contract => {
  return new ethers.Contract(address, ERC2771CustomForwarderAbi.abi, signer)
}

export const contractInterface = new ethers.Interface([
  ...AccessControlAbi.abi,
  ...ERC2771CustomForwarderAbi.abi,
  ...IdentityRegistryAbi.abi,
  ...InterestPaymentAbi.abi,
  ...PurchaseContractAbi.abi,
  ...RestrictedLockupTokenAbi.abi,
  ...RestrictedLockupTokenExtensionAbi.abi,
  ...RestrictedLockupTokenManagementExtensionAbi.abi,
  ...RestrictedSwapAbi.abi,
  ...SnapshotPeriodsAbi.abi,
  ...TransferRulesAbi.abi,
])

export const contractErrorDecoder = ErrorDecoder.create([
  AccessControlAbi.abi,
  ERC2771CustomForwarderAbi.abi,
  IdentityRegistryAbi.abi,
  InterestPaymentAbi.abi,
  PurchaseContractAbi.abi,
  RestrictedLockupTokenAbi.abi,
  RestrictedLockupTokenExtensionAbi.abi,
  RestrictedLockupTokenManagementExtensionAbi.abi,
  RestrictedSwapAbi.abi,
  SnapshotPeriodsAbi.abi,
  TransferRulesAbi.abi,
])
